print("######################################################")
print("########     Did you run the core first?      ########")
print("######################################################")

# Output files
vacfullout<-array(NA,dim=c(Tinit[2],resolution,301))


# Start loop 2
for (initrun in 1:Truns)
   {
   # Some starting parameters
	print(paste("Vaccination : Year = ",as.character(initrun),sep=""))
	states = ifelse(states < tol, 0, states)   
   # moving everyone, one state forward
	for (j in 99:1)
      	{
	      states[j+  1]= states[j    ]
      	states[j+101]= states[j+100]
	      states[j+201]= states[j+200]
	      }
	states[1]   = (1-p)*cohort.size 	# Partly vaccinated at birth - proportion p					
	states[101] = 0							
	states[201] = p*cohort.size
   # Time steps determined by resolution
	times  = seq(0, 1, length=resolution)
	params = matrix(c(mu = mu, betas = betas, alpha.rate=alpha.rate))
   # Output of the system of ODEs
	out = as.data.frame(lsoda(states, times, ODE, params))
	states<-as.matrix(out[resolution,])[-1]
	par(mfrow=c(1,4))
	tot<-c(as.matrix(out[resolution,2:101]))+c(as.matrix(out[resolution,102:201]))+c(as.matrix(out[resolution,202:301]))
	plot(c(as.matrix(out[resolution,2:101]))/tot,xlab="age",ylab="percentage susceptible",type="l",ylim=c(0,1),lwd=2)
	plot(c(as.matrix(out[resolution,102:201]))/tot,xlab="age",ylab="percentage infected",type="l",ylim=c(0,0.001),lwd=2)
	title(c("run",initrun))
	plot(c(as.matrix(out[resolution,202:301]))/tot,xlab="age",ylab="percentage recovered",type="l",ylim=c(0,1),lwd=2)
	plot(tot,xlab="age",ylab="percentage recovered",type="l",ylim=c(0,max(tot)),lwd=2)
   # Output matrices 
	vacfullout[initrun,,]<-as.matrix(out)
}
# End loop 2
